package com.ethon.tools;

import com.ethon.DataBase;
import com.ethon.mode.DataPoint;
import com.ethon.ui.DataField;

public class CoordTransfer {
	/**
	 * ݸݵ㣬ʼ߳ΪlengthOfImagePanelĴͼ
	 * @param pointsݳݵ
	 * @param lengthOfImagePanelͼı߳
	 */
	public void initCoord(DataPoint[] points, int lengthOfImagePanel){
		if(points==null){
			DataBase.sLen=lengthOfImagePanel;
			DataBase.xMin=0.0;
			DataBase.yMax=2.0;
			DataBase.yMin=0.0;
			DataBase.yMax=2.0;
			DataBase.scale=lengthOfImagePanel/4;
			return;
		}
		double xMin=Float.MAX_VALUE;
		double yMin=Float.MAX_VALUE;
		double xMax=0;
		double yMax=0;
		int num=points.length;
		
		for(int i=0;i<num;i++){
			DataPoint p=points[i];
			if(xMin>p.getCoord_X())	xMin=p.getCoord_X();
			if(yMin>p.getCoord_Y())	yMin=p.getCoord_Y();
			
			if(xMax<p.getCoord_X())	xMax=p.getCoord_X();
			if(yMax<p.getCoord_Y())	yMax=p.getCoord_Y();
		}
		
		double side=(xMax-xMin)>(yMax-yMin)?(xMax-xMin):(yMax-yMin);
		
		if(side==0)	DataBase.scale=20;
		else DataBase.scale=lengthOfImagePanel/(2*side);
		
		DataBase.xMin=xMin;
		DataBase.xMax=xMax;
		DataBase.yMin=yMin;
		DataBase.yMax=yMax;
		DataBase.sLen=lengthOfImagePanel;
	}

	/**
	 * ʵ꣬ڴͼϵ
	 * @param coord_Xʵʵx
	 * @param coord_Yʵʵy
	 * @return	ͼϵ  int[0]=xint[1]=y
	 */
	public int[] getPanelCoord(double coord_X, double coord_Y){
		double x=DataBase.sLen/2.0+DataBase.scale*(coord_X-(DataBase.xMin+DataBase.xMax)/2);
		double y=DataBase.sLen/2.0+DataBase.scale*(coord_Y-(DataBase.yMin+DataBase.yMax)/2);
		
		int[] array=new int[2];
		array[0]=(int)x;
		array[1]=(int)y;
		
		return array;
	}
	
	/**
	 * ڴͼϵ꣬ʵ
	 * @param panel_Coord_Xڴͼϵx
	 * @param panel_Coord_Yڴͼϵy
	 * @return	õʵ int[0]=xint[1]=y
	 */
	public double[] getCoord(int panel_Coord_X, int panel_Coord_Y){
		double x=(DataBase.xMin+DataBase.xMax)/2+(panel_Coord_X-DataBase.sLen/2.0)/DataBase.scale;
		double y=(DataBase.yMin+DataBase.yMax)/2+(panel_Coord_Y-DataBase.sLen/2.0)/DataBase.scale;
		
		return new double[]{x,y};
	}
	
	public static int getLenOfImagePanel(DataField field){
		return field.getHeight()-65>field.getWidth()?field.getWidth():field.getHeight()-65;
	}
}
